<?php

?>

<div class="row">
    <div class="col-md-12"><h1 class="page-head-line">Manage Modules</h1></div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                Search Modules
                <button type="button" class="btn btn-link" data-toggle="collapse" data-target="#search_modules">Hide Modules</button>
            </div>
            <div class="panel-body">
                <div class="collapse in" id="search_modules">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="input-group">
                                <label>Module</label>
                                <input id="txt_module" name="txt_module" value="<?= $search ?>" type="text" class="form-control" placeholder="Module" title="Module" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label>Actions</label>
                        <p>
                            <a href="<?= URL ?>sprmodule/create/"><button type="button" class="btn btn-info">New</button></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">Modules List</div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-12">  
                        <div class="table-responsive">
                            <table id="tblPR" name="tblPR" class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Module Code</th>
                                        <th>Desc</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $int_counter = 1;
                                        
                                        foreach ($modules as $m)
                                        {
                                    ?>
                                        <tr>
                                            <td><?= $int_counter ?></td>
                                            <td>
                                                <a href="<?= URL?>sprmodule/modify/<?= Crypto::simple_crypt($m->module_code, 'e') ?>">
                                                    <?= $m->module_code ?>
                                                </a>
                                            </td>
                                            <td><?= $m->module_desc ?></td>
                                        </tr>
                                    <?php
                                        $int_counter += 1;
                                    
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $("ul#main-menu li").removeClass('active');
    $("ul#main-menu li.spradmin ").addClass('active');
</script>
