<div class="row">
    <div class="col-md-12">
        <h2 class="page-head-line">Store Confirmed Prequisition Items</h2>
        <p>Choose the items that you want to purchase from the list. Click <a href="<?= URL ?>prequest/">here</a> to refresh the page.</p>
    </div>
</div>

<div class="row">
    <form id="frm_pr_search" name="frm_pr_search" class="form-horizontal" action="<?= URL ?>prequest/index" method="POST"  >
        <div class="col-xs-4">
            <div class="input-group">
                <label>Search By P.R. Number :</label>
                <input type="text" value="<?= $search_pr ?>" class="form-control" id="src_pr" name="src_pr" placeholder="PR2019-382" style="width: 100%;">
            </div>
        </div>
        <div class="col-xs-3">
            <div class="input-group">
                <label>&nbsp;</label>
                <p>
                    <button type="submit" class="btn btn-default"><span class="glyphicon glyphicon-search"></span> Find</button>

                    <a href="<?= URL ?>prequest/" class="btn btn-link"><span class="glyphicon glyphicon-refresh"></span> Refresh</a>
                </p>
                
            </div>
        </div>
    </form>
</div>

<?php 
    if ($search_result != "") {
?>
<div class="row">
    <div class="col-xs-4">
        <div class="input-group text-danger">
            <?= $search_result ?>
        </div>
    </div>
</div>
<?php
    } else {
?>
<hr />
<?php
    }
?>
<div class="row">
    <div class="col-xs-8">
        <div class="input-group">
            <label>P.R. Items List </label>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="panel-group">
<?php 
    $count = 1;
    $now = new DateTime();

    foreach ($confirmed_pritems as $pri)
    {
        $str_1month_class = "success";
        $str_1month_text_class = "default";
        $dt_updated = new DateTime($pri->pr_updated);
        $dt_deliver = new DateTime($pri->pr_request_deliverydate);
        
        $total_items_processed = (int)$pri->cart_qty + (int)$pri->po_qty + (int)$pri->amended_pri_qty;
//        $total_items_processed = (int)$pri->cart_qty - (int)$pri->po_qty;
        $max_qty = (int)$pri->pri_qty - $total_items_processed;
        $str_disable_purchase_btn = " disabled "; $str_pur_btn_name = " Processing";
        
        if($max_qty > 0) 
        {    
            if ($total_items_processed <= (int)$pri->pri_qty) 
            { 
                $str_disable_purchase_btn = ""; 
                $str_pur_btn_name = "<span class='" . "glyphicon glyphicon-plus"."'></span> Purchase";
            }

            if($now->diff($dt_deliver)->format("%r%a") <= 30) 
            { $str_1month_class = "danger"; $str_1month_text_class = "danger"; }
?>
    <div class="panel panel-<?= $str_1month_class ?>" >
        <div class="panel-body">
            <div class="row" >
                <div class="col-sm-3">
                    <b>Store Code :</b> <?php if (!empty($pri->pri_scode)) { echo $pri->pri_scode; } else { echo "-"; } ?>
                </div>                
                <div class="col-sm-3">
                    <b>Purchase Qty :</b> <span><?= $pri->pri_qty ?>&nbsp;<?= $pri->unit_short_name ?>&nbsp;(<?= $pri->unit_long_name ?>)</span>
                </div>
                <div class="col-sm-3">
                    <b>Request Qty :</b> <span><?= $pri->pri_request_qty ?>&nbsp;<?= $pri->unit_short_name ?>&nbsp;(<?= $pri->unit_long_name ?>)</span>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <b>Item Name :</b> <?= $pri->pri_item_desc ?>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <b>Confirmed Qty :</b> <?= $pri->pri_qty ?>&nbsp;<?= $pri->unit_short_name ?>
                </div>
                <div class="col-sm-6">
                    <input type="number" placeholder="Quantity" width="100%" title="Maximum <?= $max_qty ?>" 
                           id="txt_<?= Crypto::simple_crypt((string)$pri->pri_id, 'e') ?>" name="txt_<?= Crypto::simple_crypt((string)$pri->pri_id, 'e') ?>" 
                           class="number" value="<?= $max_qty ?>" max="<?= $max_qty ?>" min="0" 
                           >
                    <button id="<?= Crypto::simple_crypt((string)$pri->pri_id, 'e') ?>" name="<?= Crypto::simple_crypt((string)$pri->pri_id, 'e') ?>" 
                    class="btn btn-sm btn-primary btn_addcart" <?= $str_disable_purchase_btn ?> ><?= $str_pur_btn_name ?></button>
                    <?php
                        if ($max_qty < (int)$pri->pri_qty)
                        { echo " Maximum: " . $max_qty." "; }
                    ?>
                    <button id="" name=""  class="btn btn-sm btn-link edit_pri_qty" title="Edit Confirmed QTY" 
                            data-pri-id="<?= Crypto::simple_crypt((string)$pri->pri_id, 'e') ?>" data-max-qty="<?= $max_qty ?>" >Deduct Quantity</button>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <b>Remarks :</b> <?= $pri->pri_remarks ?>
                </div>
                
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <a href="<?= URL?>prequest/pr_print/<?= $pri->pr_no ?>" class="btn btn-sm btn-default" title="Print" target="_new" >
                        <span class="glyphicon glyphicon-print"></span>
                    </a>
                    &nbsp;
                    <button class="btn_add_purchase btn btn-sm btn-link" data-toggle="collapse" data-target="#div_<?= (string)$count.$pri->pr_no ?>">
                        <span class="glyphicon glyphicon-info-sign"></span>&nbsp;<?= $pri->pr_no ?> 
                    </button>&nbsp;
                    <span class="small text-<?= $str_1month_class ?>">
                        <b>Deliver At :</b> <?= $dt_deliver->format('d M Y') ?>, 
                        <?php
                            if ($now->diff($dt_deliver)->format("%r%a") > 0)
                            { echo $now->diff($dt_deliver)->format("%r%a") . " days left."; }
                            else
                            { echo "Overdue " . $now->diff($dt_deliver)->format("%r%a") . " days." ; }
                        ?>
                    </span>
                </div>
            </div>
        </div>
        <div class="collapse out" id="div_<?= (string)$count.$pri->pr_no ?>">
            <div class="panel panel-footer">
                <div class="row bg-<?= $str_1month_class ?>">
                    <div class="col-sm-3">
                        <b>PR # : <?= $pri->pr_no ?></b>
                    </div>
                    <div class="col-sm-4">
                        <b>Deliver At : <?= $dt_deliver->format('d M Y') ?>, <?= $now->diff($dt_deliver)->format("%r%a") ?>&nbsp;day(s) left.</b>
                    </div>
                    <div class="col-sm-4">
                        <b>Approved At : <?php
                        if(!empty($pri->pr_hod_approvedat)){
                            $dt_hodapproval = new DateTime($pri->pr_hod_approvedat);
                            echo $dt_hodapproval->format('d M Y');
                        }?></b>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        Client # : <?= $pri->pr_client_no ?>
                    </div>
                    <div class="col-sm-9">
                        Company : <?= $pri->pr_company_name ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        Work Order # : <?= $pri->pr_work_no ?>
                    </div>
                    <div class="col-sm-9">
                        Project : <?= $pri->pr_project_desc ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        Issued By : <?= $pri->pr_text_issuedby ?>
                    </div>
                    <div class="col-sm-4">
                        Required By : <?= $pri->pr_text_requiredby ?>
                    </div>
                    <div class="col-sm-4">
                        Approved By : <?= $pri->usr_fullname ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        Verified By : <?php if(!empty($pri->store_worker_name)) { echo $pri->store_worker_name; } ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <a href="<?= URL?>prequest/view_pr_details/<?= $pri->pr_no ?>" class="btn btn-sm btn-default" title="Print" target="_new" >
                            View Details
                        </a>
                        <button class="btn btn-sm btn-link" data-toggle="collapse" data-target="#div_<?= (string)$count.$pri->pr_no ?>">Hide</button>&nbsp;
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
        $count++;
        }
    }
?>
            
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal" id="amend_pri_qty_modal" name="amend_pri_qty_modal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Deduct Prequisition Item Quantity</h4>
            <p class="text-danger">You are going to modify the purchase requisition's current quantity that requested from the store.</p>
            <!--<button type="button" class="close" ><span aria-hidden="true">&times;</span></button>-->
        </div>
        <div class="modal-body">
            <form id="frm_amend_pri_qty" name="frm_amend_pri_qty" method="POST" action="<?= URL ?>prequest/amend_pri_qty" enctype="multipart/form-data" >
            <div class="row">
                <div class="col-sm-12">
                    <div class="panel-group">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <label>Current Quantity</label>
                                    <p><span id="pur_max_qty" name="pur_max_qty"></span></p>
                                </div>
                                <div class="col-sm-6">
                                    <div class="input-group">
                                        <label>Quantity you want to deduct</label>
                                        <input id="a_pri_qty_to" name="a_pri_qty_to" type="number" class="form-control number" width="100%" min="0" placeholder="New quantity" maxlength="10" required="" >
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="input-group">
                                        <label>Remark</label>
                                        <textarea id="a_pri_qty_remark" name="a_pri_qty_remark" required="" class="form-control" placeholder="Why do you need to modify its quantity?" ></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" id="a_pri_qty_from" name="a_pri_qty_from" >
        <input type="hidden" id="a_pri_id" name="a_pri_id" >
        <div class="modal-footer">
            <button type="submit" class="btn btn-sm btn-primary ">Save changes</button>
            </form>
            <button type="button" class="btn btn-sm btn-secondary" id="tn_close_amend_pri_qty" name="tn_close_amend_pri_qty">Close</button>
        </div>
    </div>
  </div>
</div>

<script type="text/javascript">

$(document).ready(function() {
    
    $(".edit_pri_qty").click(function(){
        
        var modal = document.getElementById('amend_pri_qty_modal');
        var closebtn = document.getElementById('tn_close_amend_pri_qty');
        
        var max_qty = $(this).data("max-qty");
        var a_pri_id = $(this).data("pri-id");
        
        modal.style.display = "block";
        
        $("#a_pri_qty_from").val(max_qty);
        $("#a_pri_id").val(a_pri_id);
        $("#pur_max_qty").text(max_qty);
        
        closebtn.onclick = function() 
        { 
            modal.style.display = "none";
            $("#pur_max_qty").text('');
            $("#a_pri_qty_remark").val('');
            $("#a_pri_qty_from").val('');
            $("#a_pri_id").val('');
        }
        
//        var span = document.getElementsByClassName("close")[0];
//        span.onclick = function() 
//        { modal.style.display = "none"; }
    });
    
    $("#frm_amend_pri_qty").on('submit', (function(e)
    {
        if (confirm(MsgConfirmYesNo()) === true){
            return true;
        }else{
            return false;
            ("#a_pri_qty_to").focus();
        }
    }));
    
});

</script>

