<div class="row">
    <div class="col-md-12">
        <h1 class="page-head-line" title="Head Of Department Approved Purchase Order.">H.O.D Confirmed Purchase Order (PO)</h1>
        <p>Head Of Department Approved P.O. And Waiting For Your Director To Approve It.</p>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-tabs">
                    <li class="active"><a data-toggle="tab" href="#wp">Waiting Approval</a></li>
                    <li><a data-toggle="tab" href="#disapprove">Disapproved</a></li>
                    <li><a data-toggle="tab" href="#cancelled">Canceled</a></li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">&nbsp;</div>
        </div>
      
        <div class="tab-content">
            <!-- Approved -->
            <div id="wp" class="tab-pane fade in active">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-success">
                            <div class="panel-heading">Waiting Director To Approve P.O. List</div>
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-12">                                                                                
                                        <div class="table-responsive">
                                            <table id="tblPR" name="tblPR" class="table">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th></th>
                                                        <th></th>
                                                        <th>P.O.</th>
                                                        <th></th>
                                                        <th>Total</th>
                                                        <th>From Supplier</th>
                                                        <th>Delivery Date</th>
                                                        <th>Delivery To</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $counter = 1;

                                                        foreach($AllPO as $po)
                                                        {
                                                    ?>
                                                    <tr>
                                                        <td><?= $counter ?>&nbsp;</td>
                                                        <td title="Download <?= $po->po_no ?> PDF"><a target="_blank" href="<?= URL?>prcpo/print_pdf_po/<?= $po->po_no ?>" class="btn btn-sm btn-danger"><span class="glyphicon glyphicon-save"></span>PDF</a></td>
                                                        <td title="Print Classic P.O.">
                                                            <a target="_blank" href="<?= URL?>prcpo/print_pdf_po_form1/<?= $po->po_no ?>" class="btn btn-sm btn-default"><span class="glyphicon glyphicon-print"></span></a>
                                                        </td>
                                                        <td><a target="_blank" href="<?= URL?>prcpo/view_po_details/<?= $po->po_no ?>"><?= $po->po_no ?></a></td>
                                                        <td title="Update <?= $po->po_no ?> From The Highest Approval">
                                                            <button class="btn btn-sm btn-success update_dir_po" 
                                                                     id="<?= $po->po_no ?>"  
                                                                    pono="<?= $po->po_no ?>" 
                                                                totalamt="<?= $po->po_total_amt ?>"
                                                            ><span class="glyphicon glyphicon-new-window"></span></button>
                                                        </td>
                                                        <td><?= $po->po_total_amt ?></td>
                                                        <td><?= $po->po_supplier_company_desc ?></td>
                                                        <td>
                                                            <?php 
                                                                $dt_delivery_date = new DateTime($po->po_deliverydate);
                                                                echo $dt_delivery_date->format('d M Y');
                                                            ?>
                                                        </td>
                                                        <td><?= $po->po_delivery_company_desc ?></td>
                                                        <td title="Amend <?= $po->po_no ?>.">
                                                            <button class="btn btn-sm btn-warning amend_po" 
                                                                     epo="<?= Crypto::simple_crypt($po->po_no, 'e'); ?>"  
                                                                    pono="<?= $po->po_no ?>" 
                                                            ><span class="glyphicon glyphicon-pencil"></span></button>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                        $counter = $counter + 1;
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Disapproved PO -->
            <div id="disapprove" class="tab-pane fade out">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-success">
                            <div class="panel-heading">Disapproved P.O. List</div>
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-12">                                                                                
                                        <div class="table-responsive">
                                            <table id="tblPR" name="tblPR" class="table">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>P.O.</th>
                                                        <th>Total</th>
                                                        <th>From Supplier</th>
                                                        <th>Delivery Date</th>
                                                        <th>Delivery To</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $counter = 1;

                                                        foreach($disapprove_po as $d_po)
                                                        {
                                                    ?>
                                                    <tr>
                                                        <td>
                                                            <?= $counter ?>
                                                        </td>
                                                        <td><a target="_blank" href="<?= URL?>prcpo/view_po_details/<?= $d_po->po_no ?>"><?= $d_po->po_no ?></a></td>
                                                        <td><?= $d_po->po_total_amt ?></td>
                                                        <td><?= $d_po->po_supplier_company_desc ?></td>
                                                        <td>
                                                            <?php 
                                                                $dt_delivery_date = new DateTime($d_po->po_deliverydate);
                                                                echo $dt_delivery_date->format('d M Y');
                                                            ?>
                                                        </td>
                                                        <td><?= $d_po->po_delivery_company_desc ?></td>
                                                    </tr>
                                                    <?php
                                                        $counter = $counter + 1;
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Cancelled PO -->
            <div id="cancelled" class="tab-pane fade out">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-success">
                            <div class="panel-heading">Canceled P.O. List</div>
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-12">                                                                                
                                        <div class="table-responsive">
                                            <table id="tblPR" name="tblPR" class="table">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>P.O.</th>
                                                        <th>Total</th>
                                                        <th>From Supplier</th>
                                                        <th>Delivery Date</th>
                                                        <th>Delivery To</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $counter = 1;

                                                        foreach($cancel_po as $c_po)
                                                        {
                                                    ?>
                                                    <tr>
                                                        <td>
                                                            <?= $counter ?>

                                                        </td>
                                                        <td><a target="_blank" href="<?= URL?>prcpo/view_po_details/<?= $c_po->po_no ?>"><?= $c_po->po_no ?></a></td>
                                                        <td><?= $c_po->po_total_amt ?></td>
                                                        <td><?= $c_po->po_supplier_company_desc ?></td>
                                                        <td>
                                                            <?php 
                                                                $dt_delivery_date = new DateTime($c_po->po_deliverydate);
                                                                echo $dt_delivery_date->format('d M Y');
                                                            ?>
                                                        </td>
                                                        <td><?= $c_po->po_delivery_company_desc ?></td>
                                                    </tr>
                                                    <?php
                                                        $counter = $counter + 1;
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
</div>

<!-- Proceed Approval Authentication -->
<div class="modal" id="mdl_dir_po_approval" name="mdl_dir_po_approval">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frm_po_final_approval" name="frm_po_final_approval" action="<?= URL ?>prcpo/update_po_final_approval" class="form-horizontal" method="post" >
                <div class="modal-header">
                    <span class="close">&times;</span>
                    <h4 class="modal-title">Update Highest Level Approval</h4>
                    <input id="hid_final_pono" name="hid_final_pono" type="hidden" value="">
                    <input id="hid_totalamt" name="hid_totalamt" type="hidden" value="">
                    <input id="hid_hodlimit" name="hid_hodlimit" type="hidden" value="<?= flt_hod_approval_limit ?>">
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="input-group">
                                <label><span id="spn_pono"></span> (Total Amt: <span id="spn_totalamt"></span>)</label>
                                <select name="slt_final_approval" id="slt_final_approval" class="form-control">
                                    <option value="0">= Select Approval =</option>
                                    <option value="1">Approved</option>
                                    <option value="2">Disapproved</option>
                                    <option value="3">Cancel Order</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="input-group">
                                <label>By</label>
                                <select name="slt_decision_mkr" id="slt_decision_mkr" class="form-control" disabled="">
                                    <option value="0">= Decided By =</option>
                                    <option value="3" hidden="" title="Head of Department">H.O.D (Ms. Lina Tan)</option>
                                    <option value="4" title="General Manager / Project Manager">General Manager (Mr. Lim Hock Hwa)</option>
                                    <option value="1" title="Executive Director">Exe. Director (Mr. Chua Chin Giap)</option>
                                    <option value="2" title="Managing Director">Managing Director (Mr. David Teng)</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="div_decision_rmk" name="div_decision_rmk" hidden="">
                        <div class="col-md-8">
                            <div class="input-group">
                                <label><span id="spn_decision" name="spn_decision"></span> Remarks</label>
                                <textarea id="txt_dir_decision_remarks" name="txt_dir_decision_remarks" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success" id="btn_submit_dir_po_approval" name="btn_submit_dir_po_approval" disabled="">Start Order</button>
                    <button type="button" class="btn btn-default" id="btn_close_dir_po_approval" name="btn_close_dir_po_approval">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Amend Purchase Order -->
<div class="modal" id="mdl_po_amend" name="mdl_po_amend">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frm_edit_po" name="frm_edit_po" class="form-horizontal" method="post" action="" >
                <div class="modal-header">
                    <span class="close">&times;</span>
                    <h3 class="modal-title">Change <span id="spn_amend_pono_title" ></span> To Draft.</h3>
                    <input type="hidden" id="hidpono" name="hidpono" value="" >
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12"> 
                            <p>
                                Are you sure you want to change <strong><span id="spn_amend_pono" class="text-danger bg-danger"></span></strong> to <strong>draft ?</strong>
                            </p>
                            <p>You are going to modify <b><span id="spn_amend_pono_p1" class="text-danger bg-danger"></span></b> which is already confirmed/approved and ready to proceed.</p>
                            <p class="text-danger">New Purchase Order Number <b><span id="spn_amend_pono_p2" ></span>/[numbers of modifications]</b> is going to use in this purchasing process.</p>
                        </div>
                    </div>    
                    <div class="row">
                        <div class="col-md-12">
                            <p >Enter your password to continue.</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6"> 
                            <div class="input-group">
                                <label>Email</label>
                                <p>
                                    <?= $_SESSION[Constant::SS_user_email] ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-5"> 
                            <div class="input-group">
                                <label>Password</label>
                                <input id="txt_password" name="txt_password" type="password" class="form-control" required="" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success" id="btn_submit_amend_po" name="btn_submit_amend_po" >Change To Draft</button>
                    <button type="button" class="btn btn-default" id="btn_close_amend_po" name="btn_close_amend_po">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    $("ul#main-menu li").removeClass('active');	
    $("ul#main-menu li.po ").addClass('active');
</script>
