<?php

?>

<div class="row">
    <div class="col-md-12">
        <h3 class="page-head-line" title="Purchase Order Status">Approved & Confirmed P.O. List</h3>
        <p>Your P.O. is approved by managing director, director or H.O.D.</p>
    </div>
</div>

<!-- To Order -->
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-warning">
            <div class="panel-heading">Approved & Confirmed P.O. List</div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-12">                                                                                
                        <div class="table-responsive">
                            <table id="tbl_order" name="tbl_order" class="table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>&nbsp;</th>
                                        <th>&nbsp;</th>
                                        <th>P.O.</th>
                                        <th hidden="">&nbsp;</th>
                                        <th>From Supplier</th>
                                        <th>Delivery Date</th>
                                        <th>Remaining</th>
                                        <th>Delivery To</th>
                                        <th>Total Amt</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $counter = 1;

                                        foreach($po_list as $po)
                                        {
                                    ?>
                                    <tr>
                                        <td><?= $counter ?>. </td>
                                        <td title="Download <?= $po->po_no ?> PDF"><a target="_blank" href="<?= URL?>prcpo/print_pdf_po/<?= $po->po_no ?>" class="btn btn-sm btn-danger"><span class="glyphicon glyphicon-save"></span>PDF</a></td>
                                        <td><a target="_blank" href="<?= URL?>prcpo/print_pdf_po_form1/<?= $po->po_no ?>"><button class="btn btn-sm btn-default"><span class="glyphicon glyphicon-print"></span></button></a></td>
                                        <td>
                                            <a target="_blank" href="<?= URL?>prcpo/view_po_details/<?= $po->po_no ?>"><?= $po->po_no ?></a>
                                        </td>
                                        <td hidden=""><button class="btn btn-sm btn-danger mdl_mark_complete" title="Mark as complate." 
                                                        id="<?= $po->po_no ?>"  
                                                    ><span class="glyphicon glyphicon-ok"></span></button></td>
                                        <td><?= $po->po_supplier_company_desc ?></td>
                                        <td>
                                            <?php 
                                                $dt_delivery_date = new DateTime($po->po_deliverydate);
                                                echo $dt_delivery_date->format('d M Y');
                                            ?>
                                        </td>
                                        <td>
                                            <?php 
                                                $dt_delivery_date = new DateTime($po->po_deliverydate);
                                                $dt_date_now = new DateTime('NOW');
                                                $str_date_diff = "";

                                                if ($dt_delivery_date >= $dt_date_now)
                                                { $str_date_diff = ""; } else { $str_date_diff = "Delay "; }
//                                                $date_diff = date_diff($dt_delivery_date, $dt_date_now);

                                                echo $str_date_diff . $dt_date_now->diff($dt_delivery_date)->format('%a days');
                                            ?>
                                        </td>
                                        <td><?= $po->po_delivery_company_desc ?></td>
                                        <td><?= $po->po_total_amt ?></td>
                                        <td title="Amend <?= $po->po_no ?>.">
                                            <button class="btn btn-sm btn-warning amend_po" 
                                                     epo="<?= Crypto::simple_crypt($po->po_no, 'e'); ?>"  
                                                    pono="<?= $po->po_no ?>" 
                                            ><span class="glyphicon glyphicon-pencil"></span></button>
                                        </td>
                                    </tr>
                                    <?php
                                        $counter = $counter + 1;
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Proceed Order Status Update Modal -->
<div class="modal" id="mdl_mark_complete" name="mdl_mark_complete">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frm_markcomplete" name="frm_markcomplete" action="<?= URL ?>prcpo/mark_complete" class="form-horizontal" method="POST">
            <div class="modal-header">
                <span class="close">&times;</span>
                <h4 class="modal-title">Mark As Completed</h4>
                <input id="hid_p_pono" name="hid_p_pono" type="hidden" value="">
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12"> 
                        <p>
                            Are you sure you want to mark this <strong><span id="spn_pono" name="spn_pono"></span></strong> as completed ?
                        </p>
                        <p class="text-danger">Make sure you had received all the items and checked all the items are in good condition.</p>
                    </div>
                </div>    
                <div class="row">
                    <div class="col-md-12">
                        <p >Enter your password to continue.</p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6"> 
                        <div class="input-group">
                            <label>Email</label>
                            <p>
                                <?= $_SESSION[Constant::SS_user_email] ?>
                            </p>
                        </div>
                    </div>
                    <div class="col-md-5"> 
                        <div class="input-group">
                            <label>Password</label>
                            <input id="txt_password" name="txt_password" type="password" class="form-control" required="" />
                        </div>
                    </div>
                </div>     
                
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success" id="" name="">Yes</button>
                <button type="button" class="btn btn-default" id="btn_close_po_proceed" name="btn_close_po_proceed">Cancel</button>
            </div>
            </form>
        </div>
    </div>
</div>

<!-- Amend Purchase Order -->
<div class="modal" id="mdl_po_amend" name="mdl_po_amend">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frm_edit_po" name="frm_edit_po" class="form-horizontal" method="post" action="" >
                <div class="modal-header">
                    <span class="close">&times;</span>
                    <h3 class="modal-title">Change <span id="spn_amend_pono_title" ></span> To Draft.</h3>
                    <input type="hidden" id="hidpono" name="hidpono" value="" >
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12"> 
                            <p>
                                Are you sure you want to change <strong><span id="spn_amend_pono" class="text-danger bg-danger"></span></strong> to <strong>draft ?</strong>
                            </p>
                            <p>You are going to modify <b><span id="spn_amend_pono_p1" class="text-danger bg-danger"></span></b> which is already confirmed/approved and ready to proceed.</p>
                            <p class="text-danger">New Purchase Order Number <b><span id="spn_amend_pono_p2" ></span>/[numbers of modifications]</b> is going to use in this purchasing process.</p>
                        </div>
                    </div>    
                    <div class="row">
                        <div class="col-md-12">
                            <p >Enter your password to continue.</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6"> 
                            <div class="input-group">
                                <label>Email</label>
                                <p>
                                    <?= $_SESSION[Constant::SS_user_email] ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-5"> 
                            <div class="input-group">
                                <label>Password</label>
                                <input id="txt_password" name="txt_password" type="password" class="form-control" required="" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success" id="" name="" >Change To Draft</button>
                    <button type="button" class="btn btn-default" id="btn_close_amend_po" name="btn_close_amend_po">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    $("ul#main-menu li").removeClass('active');	
    $("ul#main-menu li.order ").addClass('active');
</script>