<?php

?>

<div class="row">
    <div class="col-md-12"><h1 class="page-head-line"><?= $PO->po_no ?> Purchase Order (PO) Details</h1></div>
</div>

<!-- Order Items Listing -->
<div class="row">
    <div class="col-md-12">

        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-tabs">
                    <li class="active"><a data-toggle="tab" href="#poi">Orders List</a></li>
                    <li><a data-toggle="tab" href="#poiqt">Quotations</a></li>
                    <li><a data-toggle="tab" href="#poisl">Supplier Details</a></li>
                    <li><a data-toggle="tab" href="#poidl">Delivery Details</a></li>
                    <li><a data-toggle="tab" href="#porem">Special Remarks</a></li>
                    <li><a data-toggle="tab" href="#poconfirmation">Confirm PO</a></li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">&nbsp;</div>
        </div>

        <div class="tab-content">
            <!-- Order Items List -->
            <div id="poi" class="tab-pane fade in active">
                <div class="row">
                    <div class="col-md-12">
                        <div class="input-group">
                            <p>
                                <button type="button" id="btn_OtherCharges" name="btn_OtherCharges" class="btn btn-info new_extracharges_modal" >+ Other Charges</button>
                                <button type="button" id="btn_discount" name="btn_discount" class="btn btn-danger new_discount_modal">- Discount</button>
                                <?php if ((int)$PO->po_direct_created > 0) { ?>
                                <button type="button" id="btn_add_poitem" name="btn_add_poitem" class="btn btn-link " >Add New PO Item</button>
                                <?php } ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="input-group" id="divpoitem" name="divpoitem">
                            <table class="table" id="tblPOItems" name="tblPOItems">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">&nbsp;</th>
                                        <th scope="col">Description</th>
                                        <th scope="col">Unit</th>
                                        <th scope="col">Order Qty</th>
                                        <th scope="col" hidden="">&nbsp;</th>
                                        <th scope="col" hidden="">&nbsp;</th>
                                        <th scope="col" hidden="">&nbsp;</th>
                                        <th scope="col">Unit Price</th>
                                        <th scope="col">Total Charges</th>
                                        <th scope="col">&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody id="tbPOItemslist">
                                    <?php
                                        $counter = 1;

                                        foreach($POItems as $POItem)
                                        {
                                    ?>
                                            <tr>
                                                <td scope="row"><?= $counter ?> </td>
                                                <td>
                                                    <button class="btn btn-success editpoitem_modal" id="<?= $POItem->poi_id ?>" >Edit</button>
                                                </td>
                                                <td class="poitemdesc"><?= $POItem->poi_desc ?></td>
                                                <td class="poitemunitdesc" id="<?= $POItem->poi_unit_id ?>"><?= $POItem->poi_unit_desc ?></td>
                                                <td class="poitemqty" title="Requested:<?= $POItem->pri_qty ?> | Processing:<?= $POItem->Processed ?> | Remaining:<?php echo $POItem->pri_qty-$POItem->Processed ?>"><?= $POItem->poi_qty ?></td>
                                                <td class="prrequested" hidden=""><?= $POItem->pri_qty ?></td>
                                                <td class="poitemprocessing" hidden=""><?= $POItem->Processed ?></td>
                                                <td class="remainingorder" hidden=""><?php echo $POItem->pri_qty-$POItem->Processed ?></td>
                                                <td class="poitemunitamt" u_amount="<?= $POItem->poi_unit_amt ?>"><?= $currency_symbol . " " . $POItem->poi_unit_amt ?></td>
                                                <td class="poitemtotal" linetotal="<?= $POItem->poi_total_amt ?>" ><?= $currency_symbol . " " . $POItem->poi_total_amt ?></td>
                                                <td>
                                                    <button 
                                                        class="btn btn-link delete_poitem" 
                                                        id="<?= Crypto::simple_crypt($POItem->poi_id, 'e'); ?>" 
                                                        pono="<?= $PO->po_no ?>" >Delete</button>
                                                </td>
                                            </tr>
                                    <?php
                                            $counter = $counter + 1;
                                        }
                                    ?>

                                </tbody>
                                <tbody>
                                    <?php
                                        foreach ($other_charges as $other_charge)
                                        {
                                    ?>
                                            <tr>
                                                <td scope="row"><?= $counter ?></td>
                                                <td>
                                                    <button class="<?php if((int)$other_charge->pooc_type === 1) { echo "btn btn-primary edit_extracharges_mdl"; } elseif ((int)$other_charge->pooc_type === 2) {echo "btn btn-danger edit_discount_mdl";} else {  } ?>" 
                                                    id="<?= $other_charge->pooc_id ?>" >Edit</button>
                                                </td>
                                                
                                                <td colspan="4" class="otherchargesdesc"><?= $other_charge->pooc_desc ?></td>
                                                <td class="extra_charges" linetotal="<?= $other_charge->pooc_amend_value ?>"><?php if($other_charge->pooc_type == 1) { echo "+"; } elseif ($other_charge->pooc_type == 2) {echo "-";} ?>&nbsp;<?= $currency_symbol . " " . $other_charge->pooc_amend_value ?></td>
                                                <td>
                                                    <button class="btn btn-link del_oc" 
                                                            id="<?= Crypto::simple_crypt($other_charge->pooc_id, 'e'); ?>" 
                                                            pono="<?= $PO->po_no ?>" >Delete</button>
                                                </td>
                                            </tr>
                                    <?php
                                            $counter = $counter + 1;
                                        }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <?php 
                                    if ((float)$PO->po_rounded_amt < 1)
                                    {
                                    ?>
                                        <tr>
                                            <td colspan="5">&nbsp;</td>
                                            <th>Total Amount</th>
                                            <th><?= $currency_symbol . " " . number_format((float)$TotalAmt, 2, ".", ", ") ?></th>
                                            <td>
                                                <!--<button class="btn btn-link roundvalue" id="<?= $POItem->poi_id ?>" >Round</button>-->
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    else 
                                    {
                                    ?>
                                        <tr>
                                            <td colspan="5">&nbsp;</td>
                                            <th>Total Amount (Rounded)</th>
                                            <th title="Actual Amount is RM <?= $TotalAmt ?>"><?= $currency_symbol . " " . $PO->po_rounded_amt ?></th>
                                            <td>
                                                <!--<button class="btn btn-link roundvalue" id="<?= $POItem->poi_id ?>" >Round</button>-->
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    ?>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>                            
            </div>

            <!-- Upload Quotation Files -->
            <div id="poiqt" class="tab-pane fade in">
                <form enctype="multipart/form-data" id="frm_uploadpofile" name="frm_uploadpofile" action="<?= URL ?>prcpo/uploadpofile/<?= $PO->po_no ?>" method="post" class="form-horizontal" >
                    <div class="row">
                        <div class="col-md-5">
                            <div class="input-group">
                                <label>Your file title</label>
                                <input id="txt_doctitle" name="txt_doctitle" type="text" class="form-control" placeholder="Title / Quotation / Invoice" title="Title / Quotation / Invoice" required="" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-5">
                            <div class="input-group">
                                <label>Select file to upload</label>
                                <p><input type="file" name="upload_doc" id="upload_doc" accept=".pdf" required=""></p>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                            <div class="input-group">
                            <label>Upload file</label>
                            <p><button type="submit" value="Upload" class="btn btn-success" name="submit">Upload</button></p>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row">
                    <div class="col-md-10">
                        <div class="input-group">
                        <table>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>File Name</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 

                                $counter = 1;
                                foreach($uploaded_files as $file)
                                {
                                ?>

                                <tr>
                                    <td><?= $counter ?>. </td>
                                    <td><?= $file->prc_uf_file_title ?></td>
                                    <td><a href="<?= URL ?>uploads/doc/<?= $file->prc_uf_file_name ?>" target="_blank"><button type="button" id="btn_viewfile" class="btn btn-link"><?= $file->prc_uf_file_name ?></button>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?= URL ?>uploads/doc/<?= $file->prc_uf_file_name ?>" download >
                                            <button type="button" id="btn_downloadfile" class="btn btn-primary">Download</button>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?= URL ?>prcpo/removefile/<?= Crypto::simple_crypt($file->prc_uf_file_name, 'e') ?>/<?= Crypto::simple_crypt($file->prc_uf_id, 'e') ?>/<?= $PO->po_no ?>" >
                                            <button type="button" id="btn_removefile" class="btn btn-danger">Remove</button>
                                        </a>
                                    </td>
                                </tr>

                                <?php
                                $counter = $counter + 1;
                                }
                                ?>
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- PO Supplier Details -->
            <div id="poisl" class="tab-pane fade in">
            <div class="row"><div class="col-md-8">
            <div class="panel panel-default">
                <div class="panel-heading">Supplier Company Info</div>
                <div class="panel-body">
                <form id="frm_po_supplier" name="frm_po_supplier" action="<?= URL ?>prcpo/updateposupplier/<?= $PO->po_no ?>" class="form-horizontal" method="post">
                <!-- Order Date, Ref No -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="form-inline">
                            <label>Order Date</label>
                            <div class="input-group date form_date" data-date="" data-date-format="dd MM yyyy" data-link-field="dtOrderDate">
                                <input class="form-control" type="text" value="<?php $dt_orderdate = new DateTime($PO->po_orderdate);
                                    echo $dt_orderdate->format('d M Y');
                                ?>"
                                       id="dt" name="dt" readonly required >
                                <span class="input-group-addon"><span class="glyphicon glyphicon-remove"></span></span>
                                <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
                            </div>
                            <input type="hidden" id="dtOrderDate" name="dtOrderDate" value="<?= $PO->po_orderdate ?>" />
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group">
                            <input id="hid_po_id" name="hid_po_id" type="hidden" value="<?= Crypto::simple_crypt($PO->po_id, 'e') ?>" />
                            <label>Your Ref No.</label>
                            <input id="txtYourRefNo" name="txtYourRefNo" type="text" class="form-control" value="<?= $PO->po_your_ref_no ?>" placeholder="Quotation / Invoice" title="Quotation / Invoice" />
                        </div>
                    </div>
                </div>

                <!-- Company Name, Creditor -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="input-group">
                            <label title="Creditor Company Name">Company Name</label>
                            <input id="txtSupplierCompanyName" name="txtSupplierCompanyName" type="text" class="form-control" value="<?= $PO->po_supplier_company_desc ?>" required="" />
                            <input id="hid_SupplierCompanyID" name="hid_SupplierCompanyID" type="hidden" class="form-control" value="<?= $PO->po_supplier_company_id ?>" required="" />
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group">
                            <label title="Supplier or Creditor No">Creditor No</label>
                            <input id="txtSupplierNo" name="txtSupplierNo" type="text" class="form-control" value="<?= $PO->po_supplier_company_code ?>" />
                        </div>
                    </div>
                </div>

                <!-- Payment, Currency -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="input-group">
                            <label>Payment</label>
                            <select name="sltPaymentType" id="sltPaymentType" class="form-control">
                                <option value="0">= Payment =</option>
                                <?php 
                                        foreach($PaymentTypes as $PaymentType)
                                        {
                                            if ($PaymentType->pay_id == $PO->po_payment_type_id )
                                            {
                                ?>
                                                <option selected="" value="<?= $PaymentType->pay_id ?>" title="<?= $PaymentType->pay_remark ?>" > <?= $PaymentType->pay_type_name ?> </option>
                                <?php 
                                            }
                                            else
                                            {
                                ?>
                                                <option value="<?= $PaymentType->pay_id ?>" title="<?= $PaymentType->pay_remark ?>" > <?= $PaymentType->pay_type_name ?> </option>
                                <?php
                                            }
                                        }
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-5">
                        <div class="input-group">
                            <label>Currency</label>
                            <select name="sltCurrency" id="sltCurrency" class="form-control">
                                <option value="0">= Currency =</option>
                                <?php 
                                        foreach($Currencies as $currency)
                                        {
                                            if ($currency->crr_id == $PO->po_currency_id)
                                            {
                                ?>
                                                <option selected="" value="<?= $currency->crr_id ?>" title="<?= $currency->crr_title ?>" > <?= $currency->crr_symbol . " " . $currency->crr_code ?> </option>
                                <?php 
                                            }
                                            else
                                            {
                                ?>
                                                <option value="<?= $currency->crr_id ?>" title="<?= $currency->crr_title ?>" > <?= $currency->crr_symbol . " " . $currency->crr_code ?> </option>
                                <?php
                                            }
                                        }
                                ?>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Tel, Fax -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="input-group">
                        <label>Tel No</label>
                        <input id="txt_SupplierContact" name="txt_SupplierContact" type="text" class="form-control" value="<?= $PO->po_supplier_company_tel1 ?>" />
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group">
                            <label title="Fax No">Fax No</label>
                            <input id="txtSupplierFaxNo" name="txtSupplierFaxNo" type="text" class="form-control" value="<?= $PO->po_supplier_company_fax ?>" />
                        </div>
                    </div>
                </div>

                <!-- Att Name  -->
                <div class="row">
                    <div class="col-md-8">
                        <div class="input-group">
                        <label>Company's Attention Name</label>
                        <input id="txtSupplierAtt" name="txtSupplierAtt" type="text" class="form-control" value="<?= $PO->po_supplier_company_att ?>" />
                        </div>
                    </div>
                </div>

                <!-- Street 1 -->
                <div class="row">
                    <div class="col-md-8">
                        <div class="input-group">
                        <label>Street 1</label>
                        <input id="txtSupplierStreet1" name="txtSupplierStreet1" type="text" class="form-control" value="<?= $PO->po_supplier_company_street1 ?>" required="" maxlength="250" />
                        </div>
                    </div>
                </div> 

                <!-- Street 2 -->
                <div class="row">
                    <div class="col-md-8">
                        <div class="input-group">
                        <label>Street 2</label>
                        <input id="txtSupplierStreet2" name="txtSupplierStreet2" type="text" class="form-control" value="<?= $PO->po_supplier_company_street2 ?>" maxlength="250" />
                        </div>
                    </div>
                </div>

                <!-- Post Code, City -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                        <label>Postcode</label>
                        <input id="txtSupplierPostcode" name="txtSupplierPostcode" type="text" class="form-control number" maxlength="5" value="<?= $PO->po_supplier_company_postcode ?>" required="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="input-group">
                        <label>City</label>
                        <input id="txtSupplierCity" name="txtSupplierCity" type="text" class="form-control" value="<?= $PO->po_supplier_company_city ?>" required="" />
                        </div>
                    </div>
                </div>

                <!-- State, Country-->
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                        <label>State</label>
                        <input id="txtSupplierState" name="txtSupplierState" type="text" class="form-control" value="<?= $PO->po_supplier_company_state ?>" required="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="input-group">
                        <label>Country</label>
                        <input id="txtSupplierCountry" name="txtSupplierCountry" type="text" class="form-control" value="<?= $PO->po_supplier_company_country ?>" />
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="input-group">
                            <label>Actions</label>
                            <p>
                                <button type="submit" name="btn_updateposupplier" id="btn_updateposupplier" class="btn btn-primary">Save</button>
<!--                                            <button name="btnRemovePO" id="btnRemovePO" class="btn btn-danger">Trash</button>-->
                                <span class="spineer"> <img src="<?= URL ?>img/loading_spinner.gif"> </span>
                            </p>
                        </div>
                    </div>                            
                </div>

                </form>
                </div>
            </div>
            </div></div>
            </div>

            <!-- PO Delivery Details --> 
            <div id="poidl" class="tab-pane fade in">
            <div class="row"><div class="col-md-8">
            <div class="panel panel-default">
                <div class="panel-heading">Delivery Details</div>
                <div class="panel panel-body">
                <form id="frm_po_delivery" name="frm_po_delivery" action="<?= URL ?>prcpo/updatepodelivery/<?= $PO->po_no ?>" class="form-horizontal" method="post">

                <!-- Delivery Date -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="form-inline">
                            <label>Delivery Date</label>
                            <div class="input-group date form_date" data-date="" data-date-format="dd MM yyyy" data-link-field="dtPODeliveryDate">
                                <input class="form-control" type="text" value="<?php 
                                if (strlen($PO->po_deliverydate) > 10)
                                {
                                    $dt_deliverdate = new DateTime($PO->po_deliverydate);
                                    echo $dt_deliverdate->format('d M Y');
                                }
                                else 
                                {
                                    $dt_deliverdate = new DateTime();
                                    echo $dt_deliverdate->format('d M Y');
                                } ?>" 
                                id="dtPOD" name="dtPOD" readonly required>
                                <span class="input-group-addon"><span class="glyphicon glyphicon-remove"></span></span>
                                <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span></span>
                            </div>
                            <input 
                                value="<?php 
                                if (strlen(trim($PO->po_deliverydate)) > 10)
                                {
                                    echo $PO->po_deliverydate;
                                } 
                                else 
                                {
                                    $dt_deliverdate = new DateTime();
                                    echo $dt_deliverdate->format("Y-m-d 00:00:00");
                                }
                                ?>" 
                                type="hidden" id="dtPODeliveryDate" name="dtPODeliveryDate" />
                        </div>
                        <input id="hid_del_poid" name="hid_del_poid" type="hidden" value="<?= Crypto::simple_crypt($PO->po_id, 'e') ?>" />
                    </div>
                </div>

                <!-- Delivery Company, Delivery No -->
                <div class="row">
                    <div class="col-md-7">
                        <div class="input-group">
                        <label>Delivery Company</label>
                        <input value="<?= $PO->po_delivery_company_desc ?>" id="txtDeliveryCompanyName" name="txtDeliveryCompanyName" type="text" class="form-control" required="" />
                        <input value="<?= $PO->po_delivery_company_id ?>" id="hid_del_compname_id" name="hid_del_compname_id" type="hidden" />
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group">
                        <label>Delivery No</label>
                        <input value="<?= $PO->po_delivery_company_code ?>" id="txtDeliveryNo" name="txtDeliveryNo" type="text" class="form-control" />
                        </div>
                    </div>
                </div>

                <!-- Delivery Street 1 -->
                <div class="row">
                    <div class="col-md-8">
                        <div class="input-group">
                        <label>Street 1</label>
                        <input id="txtDeliveryStreet1" name="txtDeliveryStreet1" value="<?= $PO->po_delivery_company_street1 ?>"  type="text" class="form-control"required="" />
                        </div>
                    </div>
                </div>

                <!-- Delivery Street 2 -->
                <div class="row">
                    <div class="col-md-8">
                        <div class="input-group">
                        <label>Street 2</label>
                        <input id="txtDeliveryStreet2" name="txtDeliveryStreet2" type="text" class="form-control" value="<?= $PO->po_delivery_company_street2 ?>" />
                        </div>
                    </div>
                </div>

                <!-- Postcode, City -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                        <label>Postcode</label>
                        <input value="<?= $PO->po_delivery_company_postcode ?>" id="txtDeliveryPostcode" name="txtDeliveryPostcode" maxlength="5" type="text" class="form-control number" required="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="input-group">
                        <label>City</label>
                        <input id="txtDeliveryCity" name="txtDeliveryCity" type="text" class="form-control" value="<?= $PO->po_delivery_company_city ?>" required="" />
                        </div>
                    </div>
                </div>

                <!-- State, Country -->
                <div class="row">     
                    <div class="col-md-6">
                        <div class="input-group">
                        <label>State</label>
                        <input id="txtDeliveryState" name="txtDeliveryState" type="text" class="form-control" value="<?= $PO->po_delivery_company_state ?>" required="" />
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="input-group">
                            <label>Country</label>
                            <input id="txtDeliveryCountry" name="txtDeliveryCountry" type="text" class="form-control" value="<?php 
                            if (strlen(trim($PO->po_delivery_company_country)) > 0)
                            { echo trim($PO->po_delivery_company_country); }
                            else
                            { echo "Malaysia"; } ?>" />
                        </div>
                    </div>

                </div>     

                <div class="row">
                    <div class="col-md-12">
                        <div class="input-group">
                            <label>Actions</label>
                            <p>
                                <button type="submit" name="btn_update_podelivery" id="btn_update_podelivery" class="btn btn-primary">Save</button>
                                <span class="spineer"> <img src="<?= URL ?>img/loading_spinner.gif"> </span>
                            </p>
                        </div>
                    </div>                            
                </div>

                </form>
                </div>
            </div>
            </div>
            </div>
            </div>

            <!-- Special Remarks -->
            <div id="porem" class="tab-pane fade in">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">
                        <div class="panel-heading">Special Remarks For <?= $PO->po_no ?></div>
                        <div class="panel panel-body">
                        <form id="frm_update_poremark" name="frm_update_poremark" action="<?= URL ?>prcpo/update_poremark/<?= $PO->po_no ?>" class="form-horizontal" method="post" >
                                
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <label>Remark</label>
                                        <textarea id="txt_remark" name="txt_remark" value="" rows="2" class="form-control"><?= $TotalAmtWords .' '. $PO->po_remark ?></textarea>
                                        <input id="hid_remark_poid" name="hid_remark_poid" type="hidden" value="<?= Crypto::simple_crypt($PO->po_id, 'e') ?>" />
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <label>Action</label>
                                        <p>
                                            <button type="submit" name="btn_po_remark" id="btn_po_remark" class="btn btn-primary" title="Save Remarks">Save</button>
                                        </p>
                                    </div>
                                </div>
                            </div>
                                
                        </form>                            
                        </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Confirmation -->
            <div id="poconfirmation" class="tab-pane fade in">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">
                        <div class="panel-heading">Confirm <?= $PO->po_no ?></div>
                        <div class="panel panel-body">
                            
                        <?php   if((float)$TotalAmt > 0.00) 
                                { 
                        ?>
                            <form id="frm_proceed_draft_po" name="frm_proceed_draft_po" action="" class="form-horizontal" method="post" >
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <p>
                                            <button type="button" name="btn_proceed_draft" id="btn_proceed_draft" class="btn btn-success" title="Proceed to get the head of department's approval.">Proceed For H.O.D Approval</button>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            </form>
                        <?php   } ?>
                            
                            <div class="row">
                                <div class="col-md-7">
                                    <div class="row"></div>
                                </div>
                                <div class="col-md-5">
                                    <div class="row"><div class="col-md-12"><p>Order No: <strong><?= $PO->po_no ?></strong></p></div></div>
                                </div>
                            </div>
                            
                            <div class="row"> <!-- Supplier, Your Ref, Payment -->
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>SUPPLIER</label>
                                        </div>
                                        <div class="col-md-9">
                                            <p>
                                                <?= $PO->po_supplier_company_code ?><br>
                                                <?= $PO->po_supplier_company_desc ?><br>
                                                <?= $PO->po_supplier_company_street1 . " " . $PO->po_supplier_company_street2 ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <p>
                                                <strong>YOUR REFERENCE No.</strong><br>
                                                <?= $PO->po_your_ref_no ?><br>
                                                <strong>PAYMENT</strong><br>
                                                <?php 
                                                foreach($PaymentTypes as $PaymentType)
                                                {
                                                    if ($PaymentType->pay_id == $PO->po_payment_type_id )
                                                    {
                                                ?>
                                                        <?= $PaymentType->pay_type_name ?>
                                                <?php 
                                                    }
                                                }
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row"> <!-- Fax No, Att -->
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>FAX NO</label>
                                        </div>
                                        <div class="col-md-9">
                                            <p>
                                                <?php 
                                                    echo $PO->po_supplier_company_fax;

                                                    if(strlen(trim($PO->po_supplier_company_att)) > 0)
                                                    {
                                                        echo "&nbsp(Att: " . $PO->po_supplier_company_att . ")";
                                                    }
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row"> <!-- Delivery -->
                                <div class="col-md-7">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>DELIVERY TO</label>
                                        </div>
                                        <div class="col-md-9">
                                            <p>
                                                <?php if(strlen(trim($PO->po_delivery_company_code)) > 0) { echo $PO->po_delivery_company_code . "<br>"; } ?>
                                                <?= $PO->po_delivery_company_desc ?><br>
                                                <?= $PO->po_delivery_company_street1 . " " . $PO->po_delivery_company_street2 ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5"> <!-- Delivery Date, Order Date -->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <p>
                                                <strong>DELIVERY DATE</strong><br>
                                                <?php
                                                    if (strlen(trim($PO->po_deliverydate)) > 10)
                                                    {
                                                        $dt_deliverdate = new DateTime($PO->po_deliverydate);
                                                        echo $dt_deliverdate->format('d M Y');
                                                    }
                                                ?><br>
                                                <strong>ORDER DATE</strong><br>
                                                <?php
                                                    if (strlen(trim($PO->po_orderdate)) > 10)
                                                    {
                                                        $dt_deliverdate = new DateTime($PO->po_orderdate);
                                                        echo $dt_deliverdate->format('d M Y');
                                                    }
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group"><p>PLEASE SUPPLY THE FOLLOWING SUBJECT TO CONDITIONS ON THE BELOW WHICH BECOME PART OF THIS ORDER:-</p></div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <table border="1" style="width:100%;" class="table-striped table-bordered table-hover" >
                                            <thead>
                                                <tr>
                                                    <th scope="col">ITEM</th>
                                                    <th scope="col">QUANTITY</th>
                                                    <th scope="col">Description</th>
                                                    <th scope="col">Unit Price</th>
                                                    <th scope="col">Total Charges</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                    $counter = 1;

                                                    foreach($POItems as $POItem)
                                                    {
                                                ?>
                                                        <tr>
                                                            <td scope="row"><?= $counter ?> </td>
                                                            <td><?= $POItem->poi_qty . " " . $POItem->poi_unit_desc ?></td>
                                                            <td><?= $POItem->poi_desc ?></td>
                                                            <td style="text-align: right;"><?= $POItem->poi_unit_amt ?></td>
                                                            <td style="text-align: right;"><?= $POItem->poi_total_amt ?></td>
                                                        </tr>
                                                <?php
                                                        $counter = $counter + 1;
                                                    }
                                                ?>

                                            </tbody>
                                            <tbody>
                                                <?php
                                                    foreach ($other_charges as $other_charge)
                                                    {
                                                ?>
                                                        <tr>
                                                            <td scope="row"><?= $counter ?></td>
                                                            <td>&nbsp;</td>
                                                            <td><?= $other_charge->pooc_desc ?></td>
                                                            <td>&nbsp;</td>
                                                            <td><?php if($other_charge->pooc_type == 1) { echo "+"; } elseif ($other_charge->pooc_type == 2) {echo "-";} ?>&nbsp;<span class="amendamt"><?= $other_charge->pooc_amend_value ?></span></td>
                                                        </tr>
                                                <?php
                                                        $counter = $counter + 1;
                                                    }
                                                ?>
                                            </tbody>
                                            <tfoot>
                                                <?php 
                                                if ((float)$PO->po_rounded_amt < 1)
                                                {
                                                ?>
                                                    <tr>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <th>Total <?= $currency_symbol ?> :</th>
                                                        <th><?= number_format((float)$TotalAmt, 2, ".", ", ") ?></th>
                                                    </tr>
                                                <?php
                                                }
                                                else 
                                                {
                                                ?>
                                                    <tr>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <td>&nbsp;</td>
                                                        <th>Total <?= $currency_symbol ?> :</th>
                                                        <th title="Actual Amount is RM <?= $TotalAmt ?>"><?= $PO->po_rounded_amt ?></th>
                                                    </tr>
                                                <?php
                                                }
                                                ?>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-10">
                                    <div class="input-form">
                                        <span><strong>REMARKS : </strong><?= trim($PO->po_remark) ?></span>
                                    </div>
                                </div>
                            </div>

                        </div></div>
                    </div>
                </div>
            </div>

        </div>   

    </div>
</div>

<!-- Edit PO Item Modal -->
<div class="modal" id="myModal" name="myModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <form id="frmUpdatePOItem" name="frmUpdatePOItem" action="<?= URL ?>prcpo/updatepoitem/<?= $PO->po_no ?>" class="form-horizontal" method="post" >
              <div class="modal-header">
                  <span class="close">&times;</span>
                  <h4 class="modal-title">Purchase Order Item</h4>
              </div>
              <div class="modal-body">
                  <div class="row">
                      <div class="col-md-12">
                          <div class="input-group">
                              <label>Item Name</label>
                              <input id="txtPOItemName" name="txtPOItemName" type="text" class="form-control" value="" />
                              <input type="hidden" id="hidpoitemid" name="hidpoitemid" value="" />
                              <input type="hidden" id="hid_updatepoid" name="hid_updatepoid" value="<?php echo Crypto::simple_crypt($PO->po_id, 'e'); ?>" />
                              <input type="hidden" id="hid_updatepono" name="hid_updatepono" value="<?php echo Crypto::simple_crypt($PO->po_prefix . "-". $PO->po_no, 'e'); ?>" />
                          </div>
                      </div>
                  </div>
                  <div class="row">
                      <div class="col-md-3">
                          <div class="input-group">
                            <label>Unit</label>
                            <select name="slt_edit_poi_utypes" id="slt_edit_poi_utypes" class="form-control" <?php if ((int)$PO->po_direct_created <= 0){ echo "readonly=''"; } ?> >
                                <option value="0">= Unit Type =</option>
                                <?php 
                                    foreach($unit_types as $u_type)
                                    {
                                ?>
                                        <option value="<?= $u_type->unit_type_id ?>" title="<?= $u_type->unit_long_name ?>" > <?= $u_type->unit_long_name . " (" . $u_type->unit_short_name . ")" ?> </option>
                                <?php
                                    }
                                ?>
                            </select>
                            <!--<input id="txtPOItemUnit" name="txtPOItemUnit" type="text" class="form-control" value="" />-->
                          </div>
                      </div>
                      <div class="col-md-3">
                          <div class="input-group">
                              <label>Qty</label>
                              <input id="txtPoitemQty" name="txtPoitemQty" type="text" class="form-control number" value="" <?php if ((int)$PO->po_direct_created <= 0){ echo "readonly=''"; } ?> />
                          </div>
                      </div>
                      <div class="col-md-3">
                          <div class="input-group">
                            <label>Unit Price</label>
                            <input id="txtPoitemUnitPrice" name="txtPoitemUnitPrice" type="text" class="form-control number" value="" />
                          </div>
                      </div>
                      <div class="col-md-3">
                          <div class="input-group">
                              <label>Total Amount</label>
                              <input id="txtPOItemTotalAmt" name="txtPOItemTotalAmt" type="text" class="form-control number" readonly="" />
                              <input id="hidPOItemTotalAmt" name="hidPOItemTotalAmt" type="hidden" value="" />
                          </div>
                      </div>
                  </div>
              </div>
              <div class="modal-footer">
                  <button type="submit" id="btnUpdatePOItem" name="btnUpdatePOItem" class="btn btn-primary">Update</button>
                  <!--<button type="button" class="btn btn-danger" id="btn_remove_poi_item" name="btn_remove_poi_item">Remove</button>-->
                  <button type="button" class="btn btn-default" id="btnCloseModal" name="btnCloseModal"btn>Close</button>
              </div>
          </form>
        </div>
    </div>
</div>

<!-- Add PO Item Modal -->
<?php
    if ((int)$PO->po_direct_created > 0)
    {
?>

<div class="modal" id="mdl_add_new_poitem" name="mdl_add_new_poitem">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <form id="frm_add_poi" name="frm_add_poi" action="<?= URL ?>prcpo/add_poitem/<?= $PO->po_no ?>" class="form-horizontal" method="post" >
              <div class="modal-header">
                  <span class="close">&times;</span>
                  <h4 class="modal-title">Add Purchase Order Item</h4>
              </div>
              <div class="modal-body">
                  <div class="row">
                      <div class="col-md-12">
                          <div class="input-group">
                              <label>Item Name</label>
                              <input id="txt_add_poi_name" name="txt_add_poi_name" type="text" class="form-control" required="" value="" placeholder="Item Name" />
                              <input id="hid_pono" name="hid_pono" type="hidden" class="form-control" value="<?= $PO->po_no ?>" />
                          </div>
                      </div>
                  </div>
                  <div class="row">
                      <div class="col-md-3">
                          <div class="input-group">
                                <label>Unit</label>
                                <select name="slt_add_poi_utypes" id="slt_add_poi_utypes" class="form-control">
                                    <option value="0">= Unit Type =</option>
                                    <?php 
                                        foreach($unit_types as $u_type)
                                        {
                                    ?>
                                            <option value="<?= $u_type->unit_type_id ?>" title="<?= $u_type->unit_long_name ?>" > <?= $u_type->unit_long_name . " (" . $u_type->unit_short_name . ")" ?> </option>
                                    <?php
                                        }
                                    ?>
                                </select>
                          </div>
                      </div>
                      <div class="col-md-3">
                          <div class="input-group">
                              <label>Qty</label>
                              <input id="txt_add_poi_qty" name="txt_add_poi_qty" required="" type="text" class="form-control number" value="0" placeholder="Quantity" />
                          </div>
                      </div>
                      <div class="col-md-3">
                          <div class="input-group">
                            <label>Unit Price</label>
                            <input id="txt_add_poi_price" name="txt_add_poi_price" required="" type="text" class="form-control number" value="0" placeholder="Unit Price" />
                          </div>
                      </div>
                      <div class="col-md-3">
                          <div class="input-group">
                              <label>Total Amount</label>
                              <input id="txt_add_poi_total" name="txt_add_poi_total" type="text" class="form-control" readonly="" value="0" placeholder="Total Amount" />
                              <input id="hid_add_poi_total" name="hid_add_poi_total" type="hidden" class="form-control" value="0" />
                          </div>
                      </div>
                  </div>
              </div>
              <div class="modal-footer">
                  <button type="submit" id="btn_addnew_poi" name="btn_addnew_poi" class="btn btn-primary">Add</button>
                  <button type="button" class="btn btn-default" id="btnCloseAddMdl" name="btnCloseAddMdl"btn>Close</button>
              </div>
          </form>
        </div>
    </div>
</div>

<?php
    }
?>

<!-- Edit Extra Charges -->
<div class="modal" id="mdlExtraCharges" name="mdlExtraCharges">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frmExtraCharges" name="frmExtraCharges" action="<?= URL ?>prcpo/updateExtraCharges" class="form-horizontal" method="post">
                <div class="modal-header">
                    <span class="close">&times;</span>
                    <h4 class="modal-title">Extra Charges</h4>
                    <input id="hid_extchg_pooc_id" name="hid_extchg_pooc_id" type="hidden" value="">
                    <input id="hidExtraChargesPONo" name="hidExtraChargesPONo" type="hidden" value="<?= $PO->po_no ?>" />
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="input-group">
                                <label>Description</label>
                                <input id="txtExtraChargesDescription" name="txtExtraChargesDescription" type="text" class="form-control" placeholder="Extra Charges Description" value="" required="" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <label>Charge</label>
                                <input id="txtCharges" name="txtCharges" type="text" class="form-control number" required="" placeholder="Total Amount" value="" title="Total Amount" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="btnAddExtraCharges" name="btnAddExtraCharges" class="btn btn-primary">Add</button>
                    <button type="button" id="btnUpdateExtraCharges" name="btnUpdateExtraCharges" class="btn btn-primary">Update</button>
                    <!--<button type="button" id="btnRemoveExtraCharges" class="btn btn-danger">Remove</button>-->
                    <button type="button" class="btn btn-default" id="btnClosemdlExtraCharges">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Discount -->
<div class="modal" id="mdlDiscount" name="mdlDiscount">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frmDiscount" name="frmDiscount" action="<?= URL ?>prcpo/updateDiscount" class="form-horizontal" method="post">
                <div class="modal-header">
                    <span class="close">&times;</span>
                    <h4 class="modal-title">Discount</h4>
                    <input id="hid_dis_pooc_id" name="hid_dis_pooc_id" type="hidden" value="">
                    <input id="hidDiscountPONo" name="hidDiscountPONo" type="hidden" value="<?= $PO->po_no ?>" />
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="input-group">
                                <label>Description</label>
                                <input id="txtDiscountDescription" name="txtDiscountDescription" type="text" class="form-control" placeholder="Discount Description" value="" required="" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="input-group">
                                <label>Discount</label>
                                <input id="txtDiscount" name="txtDiscount" type="text" class="form-control number" required="" placeholder="Total Amount" value="" title="Total Amount" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="btnAddDiscount" name="btnAddDiscount" class="btn btn-primary">Add</button>
                    <button type="button" id="btnUpdateDiscount" name="btnUpdateDiscount" class="btn btn-primary">Update</button>
                    <!--<button type="button" id="btnRemoveDiscount" class="btn btn-danger">Remove</button>-->
                    <button type="button" class="btn btn-default" id="btnClosemdlDiscount">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Proceed Approval Authentication -->
<div class="modal" id="mdl_authenticate" name="mdl_authenticate">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frm_authenticate" name="frm_authenticate" action="<?= URL ?>prcpo/update_draft_wp/<?= $PO->po_no ?>" class="form-horizontal" method="post" >
                <div class="modal-header">
                    <span class="close">&times;</span>
                    <h4 class="modal-title">Authentication Required</h4>
                    <input id="hid_wp_poid" name="hid_wp_poid" type="hidden" value="<?php echo Crypto::simple_crypt($PO->po_id, 'e'); ?>">
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="input-group">
                                <p>Please enter your login username and password to proceed.</p>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                            <div class="input-group">
                                <label>Username :</label>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="input-group">
                                <input value="<?= $username ?>" id="txt_a_username" name="txt_a_username" type="text" class="form-control" placeholder="Username" required="" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                            <div class="input-group">
                                <label>Password :</label>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="input-group">
                                <input id="txt_a_pass" name="txt_a_pass" type="password" class="form-control" placeholder="password" value="" required="" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success" id="" name="">Proceed</button>
                    <button type="button" class="btn btn-default" id="btn_close_authenticate" name="btn_close_authenticate">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Round Value Modal -->
<div class="modal" id="mdlRoundValue" value="mdlRoundValue">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="frmRoundValue" name="frmRoundValue" action="<?= URL ?>prcpo/roundvalue" class="form-horizontal" method="post">
                <div class="modal-header">
                    <span class="close">&times;</span>
                    <h4 class="modal-title">Round Value</h4>
                    <input id="hidRoundPOID" name="hidRoundPOID" type="hidden" value="<?= $PO->po_id ?>" />
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="input-group">
                                <label>Current Total Amount</label>
                                <p>
                                    <label><?= $currency_symbol ?></label>&nbsp;<label id="lblTotalAmt" name="lblTotalAmt"><?= $TotalAmt ?></label>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="input-group">
                                <label>New Rounded</label>
                                <input type="text" value="<?= $PO->po_rounded_amt ?>" id="txtRoundValue" name="txtRoundValue" class="form-control number" required="" placeholder="Round Value">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="btnUpdateRound" name="btnUpdateRound" class="btn btn-primary">Round</button>
                    <!--<button type="button" id="btnCancelRound" name="btnCancelRound" class="btn btn-danger">Remove</button>-->
                    <button type="button" class="btn btn-default" id="btnClosemdlRound">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    $("ul#main-menu li").removeClass('active');	
    $("ul#main-menu li.prc ").addClass('active');
</script>
